#pragma once

#include <windows.h>

#include <d3d8.h>
#include <d3dx8.h>
#include <dsound.h>

#include <map>

#include "TextureSection.h"
#include "GameState.h"
#include "LD10Types.h"



class LD10App
{

  public:

    typedef std::map<char,tTextureSection>    tMapLetters;


    IDirect3D8*           m_pd3d;

    IDirect3DDevice8*     m_pd3dDevice;

    IDirect3DTexture8*    m_pTextureTiles;
    IDirect3DTexture8*    m_pTextureObjects;
    IDirect3DTexture8*    m_pTextureFont;
    IDirect3DTexture8*    m_pTextureFX;
    IDirect3DTexture8*    m_pTextureGUI;

    ID3DXFont*            m_pFont;

    IDirectSound*         m_pDirectSound;

    IDirectSoundBuffer*   m_pSound[LD10::SOUND_LAST_ENTRY];

    D3DPRESENT_PARAMETERS m_d3dPP;

    tMapLetters           m_mapLetters;

    HWND                  m_hWnd;

    HICON                 m_hIcon;

    DWORD                 m_dwLastTicks;

    tTextureSection       m_TexSec[LD10::TEX_LAST_ENTRY];

    tTextureSection       m_Tiles[LD10::TILE_LAST_ENTRY];

    CGameState*           m_pCurrentGameState;

    CGameState*           m_pNextState;

    bool                  m_bKeyPressed[256];
    bool                  m_bKeyReleased[256];

    float                 m_fWavyTextTimeCount;

    int                   m_MouseX;
    int                   m_MouseY;
    int                   m_MouseButtons;


    LD10App();
    ~LD10App();


    void                  RenderTextureSection( int iX, int iY, 
                                                const tTextureSection& TexSection, 
                                                DWORD dwColor = 0xffffffff, 
                                                DWORD dwColor2 = 0, 
                                                DWORD dwColor3 = 0, 
                                                DWORD dwColor4 = 0, 
                                                int iWidth = -1, int iHeight = -1, 
                                                DWORD dwAlternativeFlags = 0 );
    void                  RenderTextureSectionRotated( int iX, int iY, 
                                                       const tTextureSection& TexSection, 
                                                       float fAngle,
                                                       DWORD dwColor = 0xffffffff, 
                                                       DWORD dwColor2 = 0, 
                                                       DWORD dwColor3 = 0, 
                                                       DWORD dwColor4 = 0, 
                                                       int iWidth = -1, int iHeight = -1, 
                                                       DWORD dwAlternativeFlags = 0 );
    void                  RenderQuad( int iX, int iY, int iWidth, int iHeight,
                                      float fTU1, float fTV1,
                                      float fTU2, float fTV2,
                                      float fTU3, float fTV3,
                                      float fTU4, float fTV4,
                                      DWORD dwColor,
                                      DWORD dwColor2 = 0, 
                                      DWORD dwColor3 = 0, 
                                      DWORD dwColor4 = 0 );
    void                  RenderQuadRotated( int iX, int iY, int iWidth, int iHeight,
                                             float fTU1, float fTV1,
                                             float fTU2, float fTV2,
                                             float fTU3, float fTV3,
                                             float fTU4, float fTV4,
                                             float fAngle,
                                             DWORD dwColor,
                                             DWORD dwColor2 = 0, 
                                             DWORD dwColor3 = 0, 
                                             DWORD dwColor4 = 0 );

    void                  Print( int iX, int iY, const char* szText, DWORD dwColor = 0xffffffff );
    void                  PrintNice( int iX, int iY, const char* szText, DWORD dwColor = 0xffffffff );
    void                  PrintNiceCentered( int iX, int iY, const char* szText, DWORD dwColor = 0xffffffff, bool bWavy = false );
    void                  PrintNiceCenteredWavy( int iX, int iY, const char* szText, DWORD dwColor = 0xffffffff );

    IDirect3DTexture8*    LoadTexture( const char* szFileName, DWORD dwColorKey = 0 );
    IDirectSoundBuffer*   LoadWave( const char* szFileName );

    static LRESULT        StaticWindowProc( HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam );
    LRESULT               WindowProc( HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam );

    void                  RenderFrame();
    void                  UpdateFrame( const float fElapsedTime );

    void                  NextState( CGameState* pNewState );

    void                  Run();

    void                  LoadResources();
    void                  UnloadResources();
    void                  Load3dResources();
    void                  Unload3dResources();

    void                  PlaySound( LD10::SoundTypes Sound );
    void                  LoopSound( LD10::SoundTypes Sound );
    void                  StopSound( LD10::SoundTypes Sound );

};


extern LD10App    theApp;

